﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.DirectoryServices;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace Supersofta
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public string kohde;

        public MainWindow()
        {
            InitializeComponent();
            ldapTree();
        }

        private void ldapTree()
        {
            DirectoryEntry entry = new DirectoryEntry("LDAP://10.50.3.201/OU=Konetilit,DC=ad,DC=tredu,DC=fi");
            DirectorySearcher mySearcher = new DirectorySearcher(entry);
            mySearcher.Filter = ("(objectClass=organizationalUnit)");
            mySearcher.SizeLimit = int.MaxValue;
            mySearcher.PageSize = int.MaxValue;

            //ldaptree.Items.Add(entry.Name);
            TreeViewItem alku = new TreeViewItem() { Header = "-- Vaihda OU:ta --" };
            ldaptree.Items.Add(alku);
            luoLdapPuu(entry, alku);

            mySearcher.Dispose();
            //entry.Dispose();

        }

        private void luoLdapPuu(DirectoryEntry e, TreeViewItem t)
        {

            if (e.Name.StartsWith("OU"))
            {
                TreeViewItem uusiOU = new TreeViewItem() { Header = e.Name };
                uusiOU.MouseRightButtonDown += (sender1, e1) => TreeViewItem_MouseRightButtonDown(sender1, e1, e);
                t.Items.Add(uusiOU);

                if (e.Children != null)
                {
                    foreach (DirectoryEntry child in e.Children)
                    {
                        luoLdapPuu(child, uusiOU);
                        //var moomoo = child.Path;
                    }
                }
            }
        }

        public void TreeViewItem_MouseRightButtonDown(object sender, MouseEventArgs e, DirectoryEntry de)
        {
            TreeViewItem item = sender as TreeViewItem;
            if (item != null)
            {
                item.Focus();
                kohde = de.Path.Replace("LDAP://10.50.3.201/", "");

                e.Handled = true;
            }
        }

        public string txtviesti
        {
            get
            {
                return viesti.Text;
            }
        }


        private void Button_Click(object sender, RoutedEventArgs e)
        {

            System.Diagnostics.Process process = new System.Diagnostics.Process();
            System.Diagnostics.ProcessStartInfo startInfo = new System.Diagnostics.ProcessStartInfo();            
            startInfo.WindowStyle = System.Diagnostics.ProcessWindowStyle.Normal;
            startInfo.FileName = "msg.exe";
            startInfo.WindowStyle = ProcessWindowStyle.Normal;
            startInfo.ErrorDialog = true;
            startInfo.Arguments = kohde + viesti;
            process = Process.Start(startInfo);    
            
        }
    }        
}